/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.media.codec.atrac3plus;

import jpcsp.Memory;
import jpcsp.media.codec.ICodec;
import jpcsp.media.codec.atrac3plus.Atrac;
import jpcsp.media.codec.atrac3plus.Atrac3plusDsp;
import jpcsp.media.codec.atrac3plus.ChannelUnit;
import jpcsp.media.codec.atrac3plus.Context;
import jpcsp.media.codec.util.BitReader;
import jpcsp.media.codec.util.CodecUtils;
import jpcsp.media.codec.util.FFT;
import org.apache.log4j.Logger;

public class Atrac3plusDecoder
implements ICodec {
    public static Logger log = Logger.getLogger((String)"atrac3plus");
    public static final int AT3P_ERROR = -1;
    public static final int CH_UNIT_MONO = 0;
    public static final int CH_UNIT_STEREO = 1;
    public static final int CH_UNIT_EXTENSION = 2;
    public static final int CH_UNIT_TERMINATOR = 3;
    public static final int ATRAC3P_POWER_COMP_OFF = 15;
    public static final int ATRAC3P_SUBBANDS = 16;
    public static final int ATRAC3P_SUBBAND_SAMPLES = 128;
    public static final int ATRAC3P_FRAME_SAMPLES = 2048;
    public static final int ATRAC3P_PQF_FIR_LEN = 12;
    private Context ctx;

    @Override
    public int init(int bytesPerFrame, int channels, int outputChannels, int codingMode) {
        ChannelUnit.init();
        this.ctx = new Context();
        this.ctx.outputChannels = outputChannels;
        this.ctx.dsp = new Atrac3plusDsp();
        for (int i = 0; i < this.ctx.numChannelBlocks; ++i) {
            this.ctx.channelUnits[i] = new ChannelUnit();
            this.ctx.channelUnits[i].setDsp(this.ctx.dsp);
        }
        this.ctx.ipqfDctCtx = new FFT();
        this.ctx.ipqfDctCtx.mdctInit(5, true, 9.460189386888177E-4);
        this.ctx.mdctCtx = new FFT();
        this.ctx.dsp.initImdct(this.ctx.mdctCtx);
        Atrac3plusDsp.initWaveSynth();
        this.ctx.gaincCtx = new Atrac();
        this.ctx.gaincCtx.initGainCompensation(6, 2);
        return 0;
    }

    @Override
    public int decode(Memory inputMemory, int inputAddr, int inputLength, Memory outputMemory, int outputAddr) {
        int chUnitId;
        if (this.ctx == null) {
            return -1;
        }
        if (inputLength < 0) {
            return -1;
        }
        if (inputLength == 0) {
            return 0;
        }
        this.ctx.br = new BitReader(inputMemory, inputAddr, inputLength);
        if (this.ctx.br.readBool()) {
            log.error((Object)String.format("Invalid start bit", new Object[0]));
            return -1;
        }
        int chBlock = 0;
        int channelsToProcess = 0;
        while (this.ctx.br.getBitsLeft() >= 2 && (chUnitId = this.ctx.br.read(2)) != 3) {
            if (chUnitId == 2) {
                log.warn((Object)String.format("Non implemented channel unit extension", new Object[0]));
                return -1;
            }
            if (chBlock >= this.ctx.channelUnits.length || this.ctx.channelUnits[chBlock] == null) {
                log.error((Object)String.format("Too many channel blocks", new Object[0]));
                return -1;
            }
            this.ctx.channelUnits[chBlock].setBitReader(this.ctx.br);
            this.ctx.channelUnits[chBlock].ctx.unitType = chUnitId;
            channelsToProcess = chUnitId + 1;
            this.ctx.channelUnits[chBlock].setNumChannels(channelsToProcess);
            int ret = this.ctx.channelUnits[chBlock].decode();
            if (ret < 0) {
                return ret;
            }
            this.ctx.channelUnits[chBlock].decodeResidualSpectrum(this.ctx.samples);
            this.ctx.channelUnits[chBlock].reconstructFrame(this.ctx);
            CodecUtils.writeOutput(this.ctx.outpBuf, outputMemory, outputAddr, 2048, channelsToProcess, this.ctx.outputChannels);
            ++chBlock;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("Bytes read 0x%X", this.ctx.br.getBytesRead()));
        }
        return this.ctx.br.getBytesRead();
    }

    @Override
    public int getNumberOfSamples() {
        return 2048;
    }
}

